$(function () {
    
    $('.btn_imprimir').on('click', function() {
        var id = $(this).data("id");
        window.open(APP_URL+'/../pdf/imprimeProformaTicket.php?id_proforma='+id, '_blank');
    }); 

    $('.btn_imprimir_a4').on('click', function() {
        var id = $(this).data("id");
        window.open(APP_URL+'/../pdf/imprimeProformaA4.php?id_proforma='+id, '_blank');
    }); 

    /******************************************************************************/
	/* ANULAR DEUDA
	/******************************************************************************/

	$('.btn_anular').on('click', function() {
		$('#update_modal').modal({
			closable: false,
	    	onApprove : function() {
	    		sendForm();
		    }
  		}).modal('show');
  	});
  	
	function sendForm() {

	    var id_proforma = $('#id_proforma').val();

      $.requestApi('/proforma/anular', {'id_proforma' : id_proforma}, 'POST', function (resolve) {
	        if (resolve) {
	            $.showMessages(resolve, true, APP_URL+'/proforma/listar');
	        }
	    });
        
        return false;
	};


    /******************************************************************************/
	/* BOTON AGREGAR 
	/******************************************************************************/
	$('.btn_agregar').on('click', function() {
  		var count=$("#tbody tr:first > td").length;
    	if (count > 0 && ($('#total_venta') !== "")) {
    		if ($('#total_venta').val() !== "") {
			  	$('#agregar_modal').modal({
	  				closable: false,
			    	onApprove : function() {
			    		sendForm2();
				    }
		  		}).modal('show'); 
			} else {
				swal("Los precios", "de los productos no son validos", "warning");
			}
		} else {
			swal("Por favor", "agregue algun producto a la lista", "warning");
		}
  	});	

  	function sendForm2() {
	    var data = $('#frmAgregar').serialize()+ "&total=" + $('#total_venta').val();
        $.requestApi('/proforma/agregar_item', data, 'POST', function (resolve) {
	        if (resolve) {
	            $.showMessages(resolve, true, APP_URL+'/proforma/detalles/'+$('#id_proforma').val());
	        }
	    });
        return false;
	};
    /******************************************************************************/
	/* AGREGAR PRODUCTO A LA LISTA DE PRODUCTOS 
	/******************************************************************************/

	$('.btn_modal_producto').on('click', function() {
  		$('#buscar_producto_modal').modal('show'); 
  		$('#buscar_producto').val('');
  		//resetearTablaProducto();
  	});	

	$('[name="id_prod"]').dropdown({
        showOnFocus:false,
        placeholder: 'Ingrese nombre de producto a buscar',
        direction: 'downward',
        fields: {
        	remoteValues: 'productos',
        	name: "nombre",
        	value: "id_producto"
        },
     	apiSettings: {
	        method: 'get',
	        cache: false,
	        url: APP_URL + '/xml/productos/{query}',
	    },

	    onChange: function(value, text, $selectedItem) {
	    	$._requestApi('/producto_local/getById', {id_producto : value }, 'GET', function (resolve) {
		        if (resolve) {
		        	if (resolve.id_producto) {
			        	agregarTabla(resolve);	
			        	
			        }
		        }	
		    });
	    }
	});

	/*********************************************************************************************************/
	/* funcion agregar a tabla
	/*********************************************************************************************************/

 	function agregarTabla(data) {
  		if (verificaExite(data.id_producto)) {
  			cant = parseFloat($('#cant'+data.id_producto).val());
  			$('#cant'+data.id_producto).val(cant + 1);
  			calculaSubtotal(data.id_producto, data.producto.valor_impuesto);
  			calcularTotal();

  		} else {
  			agregarFila(data);
  		}
        
  	}


  	function agregarFila(data) {

		var nuevoProducto=''+
            '<tr class="rows" id="'+data.id_producto+'">'+
                '<td><input type="hidden" name="id_producto[]" value="'+data.id_producto+'"/>'+data.producto.nombre+' '+(data.producto.descripcion !== null ? data.producto.descripcion : '')+'</td>'+
                '<td><input type="text" name="cantidad[]" class="cant '+data.id_producto+'" id="cant'+data.id_producto+'" value="1" size="1"></td>'+
                //'<td class="warning"><input type="hidden" name="precio_venta[]" id="prec'+data.id_producto+'" value="'+data.producto.precio+'"/>'+data.producto.precio+'</td>'+
                '<td class="warning"><input type="text" readonly class="prec '+data.id_producto+'"  name="precio_venta[]" id="prec'+data.id_producto+'" value="'+data.producto.precio+'" size="2"/></td>'+
                '<td><input type="text" name="descuento[]" class="desc '+data.id_producto+'" id="desc'+data.id_producto+'" value="0" size="1"></td>'+
                '<td style="display:none"><input type="hidden" name="impuesto[]" class="impu '+data.producto.valor_impuesto+'" id="impu'+data.id_producto+'" value="'+(data.producto.precio-(data.producto.precio/(1+(data.producto.valor_impuesto/100)))).toFixed(6)+'"/></td>'+
                '<td class="positive"><input type="hidden" name="subtotal[]" id="subt'+data.id_producto+'" value="'+data.producto.precio+'"/><span id="v_subt'+data.id_producto+'">'+data.producto.precio+'</span></td>'+
                '<td><div class="ui mini vertical animated red button" onclick="quitarTabla(this)" title="Quitar de la lista"><div class="hidden content">Quitar</div><div class="visible content"><i class="times icon"></i></div></div></td>'+
            '</tr>';
          
        $("#tbody").append(nuevoProducto);

        calcularTotal(); 
  	}

  	/*********************************************************************************************************/
	/* start: calcula precios al presionar tecla
	/*********************************************************************************************************/
	$('body').on('click', '.prec', function(){
	 	//$(this).attr("readonly", false);
	});

  	$('body').on('keyup', '.cant', function(){

  		$(this).val($(this).val().trim());
    	var arr = $(this).attr('class').split(" ");
    	var imp = $('#impu'+arr[1]).attr('class').split(" ");
        calculaSubtotal(arr[1], imp[1]);
        calcularTotal(); 
	    
    });

    $('body').on('keyup', '.desc', function(){

    	$(this).val($(this).val().trim());
		var arr = $(this).attr('class').split(" ");
    	var imp = $('#impu'+arr[1]).attr('class').split(" ");
        calculaSubtotal(arr[1], imp[1]);
        calcularTotal(); 
    	
    });

    $('body').on('keyup', '.prec', function(){

    	$(this).val($(this).val().trim());
		var arr = $(this).attr('class').split(" ");
    	var imp = $('#impu'+arr[1]).attr('class').split(" ");
        calculaSubtotal(arr[1], imp[1]);
        calcularTotal(); 
    	
    });


    /*********************************************************************************************************/
  /* modal agregar NUEVO producto
  /*********************************************************************************************************/   
    $('.btn_nuevo_producto').on('click', function() {
      $('#nuevo_producto_modal').modal('show'); 
    }); 

    $('#frmNuevoProducto').form({
      keyboardShortcuts: false,
      fields: {
          nombre: {
            rules: [{ type : 'empty', prompt : 'Complete este campo'}]
        },

        precio: {
            rules: [
              { type : 'empty', prompt : 'Complete este campo'},
              { type   : 'regExp[/^[0-9]+([\.]{1}[0-9]+)?$/]', prompt : 'Ingrese un valor valido'},
            ]
        },

      },
      inline : true,
    });

    $('.btn_registrar_producto').on('click', function() {
        if ($('#frmNuevoProducto').form('is valid')) {
          $("#loader_producto").removeClass('disabled');
          $("#loader_producto").addClass('active');
          var data = $('#frmNuevoProducto').serialize()+ "&id_proforma=" + $('#id_proforma').val();

            $._requestApi('/producto/registrar_proforma', data, 'POST', function (resolve) {
                if (resolve) {
                    $.showMessages(resolve, true, APP_URL+'/proforma/detalles/'+$('#id_proforma').val());
                }
            });

        } else {
          $('#frmNuevoProducto').form('validate form');
        }
    });

/*********************************************************************************************************/
/* quitar ITEM
/*********************************************************************************************************/


    $('.button_delete_modal').on('click', function() {

        var id = $(this).data("id"); 
    
        $('#delete_modal').modal({
            closable: false,
            onApprove : function() {
                sendDelete(id);
            }
        }).modal('show');  
    });        

    function sendDelete(id) {

        var data = {id_detalle_proforma : id,  id_proforma : $('#id_proforma').val() };

        $.requestApi('/proforma/quitar_item', data, 'POST', function (resolve) {
            if (resolve) {
                $.showMessages(resolve, true, APP_URL+'/proforma/detalles/'+$('#id_proforma').val());
            }
        });
        
        return false;
    };      



});



/*********************************************************************************************************/
/* funciones de calculo
/*********************************************************************************************************/

function calculaSubtotal(id, imp) { 
	var subt = (parseFloat($('#prec'+id).val()).toFixed(2)*parseFloat($('#cant'+id).val()).toFixed(2)) - parseFloat($('#desc'+id).val()).toFixed(2);
	$('#subt'+id).val(validaNumero($('#prec'+id).val()) && validaNumero($('#cant'+id).val()) && validaNumero($('#desc'+id).val()) && (subt > 0) ? subt.toFixed(2) : '');
    $('#v_subt'+id).text(validaNumero($('#prec'+id).val()) && validaNumero($('#cant'+id).val()) && validaNumero($('#desc'+id).val()) && (subt > 0) ? subt.toFixed(2) : '');
    calculaImpuesto(id, imp);
}

function calculaImpuesto(id, v_impu) {
	var impu = parseFloat($('#subt'+id).val()).toFixed(2) - parseFloat($('#subt'+id).val()).toFixed(2)/(1+(v_impu/100));
	$('#impu'+id).val(validaNumero($('#subt'+id).val()) && !isNaN(impu) ? impu.toFixed(6) : '');
}

function calculaVuelto(total, efectivo) { 
	var vuelto = efectivo-total;
	$('#vuelto').val(validaNumero(vuelto) && validaNumero(efectivo) && (vuelto > 0) ? vuelto.toFixed(2) : '0.00');
}

function validaNumero(valor) {
    var expresion=/^[0-9]+([\.]{1}[0-9]+)?$/;
    return !expresion.test(valor) ? false : true; 
}

function verificaExite(id) {
	exist = false;
	$('#tbody tr').each(function() {
    	if (this.id == id) {
    		exist = true;
    	}
  	});

	return exist;
}

function calcularTotal() {
	var total = 0;
	$('#tbody').find('tr').each(function(index, element) {
	    $(element).find('td').each(function(index1, element1) {
	        if(index1==5) { //Index empieza en 0 incluye hiddens
	            temp = parseFloat($(element1).text());
	            total+= temp;
	        }
	    });
	});
	$('#total_venta').val(!isNaN(total) ? total.toFixed(2) : '');
}

function quitarTabla(elem) {
    var elementoEliminar=$(elem).parent().parent();
    $(elementoEliminar).remove();
    calcularTotal();
}


