$(function () {

	$.fn.form.settings.rules.docExiste = function(value) {
	  	return (verificaExiste('numero_documento', value) > 0 ? false : true);
	};

	function verificaExiste(field, param) {
     	var count;
     	$.ajax({
     		async: false,
            url: APP_URL+'/cliente/existeCampo',
            headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') },
            type: 'GET',
            dataType: 'json',
            data: { campo: field, valor: param},
            success: function (data) {
                count = data;
            }
        });
        return count;
	};

    $('#frmNuevo').form({
    	keyboardShortcuts: false,
    	fields: {
	      	nombre: {
		        rules: [{ type : 'empty', prompt : 'Complete este campo'}]
		    },
		    numero_documento: {
		        rules: [
		        	{ type : 'docExiste', prompt : 'El numero de documento ya fue registrado'},
		        	{ type : 'empty', prompt : 'Complete este campo'},
		        	{ type : 'integer', prompt : 'Ingrese solo números'}
		        ]
		    },
		    id_tipo_documento: {
		        rules: [{ type : 'empty', prompt : 'Seleccione una opción'}]
		    },
		    telefono: {
		    	optional: true,
		        rules: [{ type : 'integer', prompt : 'Ingrese solo números'}]
		    },
		    email: {
		    	optional: true,
		        rules: [{ type : 'email', prompt : 'Ingrese un email válido'}]
		    },
    	},
    	inline : true,
    });

    $('[name="id_tipo_documento"]').change(function() {
	  	
	  	var option= $("option:selected", this).text();

	  	if (option == "RUC") {
	  		$('input[name="numero_documento"]').attr('maxlength', 11);
	  		$('#frmNuevo').form('add rule', 'numero_documento', {
		        rules: [
		        	{ type : 'docExiste', prompt : 'El numero de documento ya fue registrado'},
		        	{ type : 'integer', prompt : 'Ingrese solo números'},
		        	{ type : 'exactLength[11]', prompt : 'El RUC debe tener {ruleValue} digitos'}
		        ]
		    });
	  	}
	  	if (option == "DNI") {
	  		$('input[name="numero_documento"]').attr('maxlength', 8);
	  		$('#frmNuevo').form('add rule', 'numero_documento', {
		        rules: [
		        	{ type : 'docExiste', prompt : 'El numero de documento ya fue registrado'},
		        	{ type : 'integer', prompt : 'Ingrese solo números'},
		        	{ type : 'exactLength[8]', prompt : 'El DNI debe tener {ruleValue} digitos'}
		        ]
		    });
	  	}
	});

	$('.btn_registrar').on('click', function() {
		if ($('#frmNuevo').form('is valid')) {
			$('#register_modal').modal({
  				closable: false,
		    	onApprove : function() {
		    		sendForm();
			    }
	  		}).modal('show'); 
		} else {
			$('#frmNuevo').form('validate form');
		}
  	});

	function sendForm() {

	    var data = $('#frmNuevo').serialize();
        $.requestApi('/cliente/registrar', data, 'POST', function (resolve) {
	        if (resolve) {
	            if (resolve.message === "success") {
	                $.Helper.clearFields("#frmNuevo");
	            }
	            $.showMessages(resolve);
	        }
	    });
        
        return false;
	};

});
